
*****************************************************
*           REGRESSIONSANALYSE                      *
*              Josef Brüderl                        *
*              November 2018                        *
*****************************************************

clear 
set more off
version 15

* Daten: ALLBUS 2002
cd "C:\Users\Brüderl\LRZ Sync+Share\Vorlesung Querschnittsdatenanalyse\Do Files\"
use  AllbReg, clear


********  Datenaufbereitung
* Nur hauptberuflich ganztags, bis Alter 65
keep if  hauptber == 1
keep if  alter <  66


* Ein komplexes lineares Regressionsmodell
* aV:  monatliches Nettoeinkommen in Euro
* uVs: Bildungsjahre, Frau-Dummy, Ost-Dummy, 
*      Berufliche Stellung (Arbeiter, Angestellter, Beamter, Selbständiger), 
*      Berufserfahrung
*  - quadratischer EXP-Effekte
*  - Interaktion von OST mit BERUF und EXP

regress eink bild frau i.ost##(i.beruf c.exp##c.exp)  

* Die resultierende Regressionstabelle kann kein Mensch interpretieren!
* Das gilt generell bei komplexen, linearen Modellen. Noch viel
* schwieriger ist es, die Tabellen nicht-linearer Modelle (Logit, Ologit, ..)
* zu verstehen. Beim Mlogit führen die Logit-Koeffizienten die meisten
* Forscher sogar in die Irre! Es ist schlicht Papierverschwendung, 
* solche Regressionstabellen abzudrucken!
* Stattdessen sagen ein paar Plots viel mehr, als all die Zahlen.

   
*--------------------------------------------------------------------
* Regressionsplots zur Veranschaulichung von Regressionsergebnissen
*--------------------------------------------------------------------  

* I) Koeffizientenplots
coefplot, drop(_cons) xline(0) base                    // hier nicht sehr hilfreich

* Plot der "Average Marginal Effects" (AME) 
margins, dydx(*)               
marginsplot, horizontal xline(0) plotopts(connect(i))  // auch nicht sehr informativ
   

* II) Profile Plot (PP)
* Insbesondere bei nicht-linearen Effekten ist es sehr hilfreich,
* die Vorhersagewerte zu plotten (da ja die AMEs nur den mittleren ME geben)

margins beruf                        //PP mit kategorialer Variable
marginsplot, plotopts(connect(i))

margins, at(exp=(0(5)50))            //PP mit metrischer Variable
marginsplot, recast(line) recastci(rarea)

margins beruf#ost                    //Interaktion zweier kategorialer Variablen
marginsplot, plotopts(connect(i))

margins ost, at(exp=(0(5)50))    //Interaktion metrischer und kategorialer Variable
marginsplot, noci recast(line)


* III) Conditional-Effects Plot (CEP)
* Bei nicht-linearen Effekten und bei Interaktionseffekten sind die ME konditional.
* Deshalb sollte man sich die Marginaleffekte auch in Abhängigkeit von der
* verursachenden Variable anschauen.

* Polynom ------------------------------------------------------
margins ost, dydx(exp) at(exp=(0(5)50))  //AMEs von EXP (getrennt West/Ost)
marginsplot, recast(line) recastci(rline) yline(0) by(ost) 

* Interaktion ---------------------------------------------------
* Wegen Symmetrie hier immer 2 Plots
margins ost, dydx(beruf)                 //AMEs Beruf nach Ost (CEP I)
marginsplot, x(_deriv) horizontal xline(0) plotopts(connect(i))

margins beruf, dydx(ost)                 //AMEs Ost nach Beruf (CEP II)
marginsplot, horizontal xline(0) plotopts(connect(i))

margins ost, dydx(exp)                 //AMEs Exp nach Ost (CEP I)
marginsplot, horizontal xline(0) plotopts(connect(i))

margins, dydx(ost) at(exp=(0(2)50))   //AMEs Ost nach Exp (CEP II)
marginsplot, recast(line) recastci(rline) yline(0)


